/*--------------------------------------------------------------------------*\

    FILE....: vpb_ioctl.h
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 22/9/99

    This file defines the interface between the kernel mode 
    device driver and the user mode driver code.  This interface
    supports both ISA and PCI cards with the same kernel mode
    driver.
	
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __IOCTL__
#define __IOCTL__


typedef struct {
  unsigned short port;
  unsigned short *data;
  int            length;
  int	         dsp_addr;
  int            pci_num;
} VPB_DATA;
#define	VPB_IOC_MAGIC	'v'

typedef struct {
  unsigned short *data;
  int            length;
  int	         vpbhp_addr;
  int            pci_num;
} VPBHP_DATA;
#define	VPBHP_IOC_MAGIC	'h'

#ifdef __FreeBSD__
//#ifndef KERNEL
//#include <sys/types.h>
//#endif
#include <sys/ioccom.h>

/* ISA commands */

#define	VPB_IOC_ADD_BOARD	_IOW(VPB_IOC_MAGIC, 1, VPB_DATA)
#define	VPB_IOC_REMOVE_BOARD	_IOW(VPB_IOC_MAGIC, 2, VPB_DATA)
#define	VPB_IOC_BLOCK_WRITE	_IOW(VPB_IOC_MAGIC, 3, VPB_DATA)
#define	VPB_IOC_BLOCK_READ	_IOW(VPB_IOC_MAGIC, 4, VPB_DATA)

/* PCI commands */
#define VPB_IOC_PCI_BLOCK_WRITE    _IOW(VPB_IOC_MAGIC, 5, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_READ     _IOW(VPB_IOC_MAGIC, 6, VPB_DATA)
#define VPB_IOC_PCI_DSP_RESET      _IOW(VPB_IOC_MAGIC, 7, VPB_DATA)
#define VPB_IOC_PCI_DSP_RUN        _IOW(VPB_IOC_MAGIC, 8, VPB_DATA)
#define VPB_IOC_PCI_GET_NUM_CARDS  _IOW(VPB_IOC_MAGIC, 9, VPB_DATA)
#define VPB_IOC_PCI_BLOCK_EEREAD   _IOW(VPB_IOC_MAGIC, 10, VPB_DATA)

#define VPBHP_IOC_PCI_BLOCK_WRITE         _IOW(VPBHP_IOC_MAGIC, 1, VPBHP_DATA)
#define VPBHP_IOC_PCI_BLOCK_READ          _IOW(VPBHP_IOC_MAGIC, 2, VPBHP_DATA)
#define VPBHP_IOC_PCI_WD_EN_L             _IOW(VPBHP_IOC_MAGIC, 3, VPBHP_DATA)
#define VPBHP_IOC_PCI_WD_EN_H             _IOW(VPBHP_IOC_MAGIC, 4, VPBHP_DATA)
#define VPBHP_IOC_PCI_WDR_L               _IOW(VPBHP_IOC_MAGIC, 5, VPBHP_DATA)
#define VPBHP_IOC_PCI_WDR_H               _IOW(VPBHP_IOC_MAGIC, 6, VPBHP_DATA)
#define VPBHP_IOC_PCI_GET_NUM_CARDS       _IOW(VPBHP_IOC_MAGIC, 7, VPBHP_DATA)
#define VPBHP_IOC_PCI_TX_FIFO_BLOCK_WRITE _IOW(VPBHP_IOC_MAGIC, 8, VPBHP_DATA)
#define VPBHP_IOC_PCI_RX_FIFO_BLOCK_READ  _IOW(VPBHP_IOC_MAGIC, 9, VPBHP_DATA)
#define VPBHP_IOC_PCI_TX_FIFO_HOW_EMPTY   _IOW(VPBHP_IOC_MAGIC, 10, VPBHP_DATA)
#define VPBHP_IOC_PCI_RX_FIFO_HOW_FULL    _IOW(VPBHP_IOC_MAGIC, 11, VPBHP_DATA)
#define VPBHP_IOC_PCI_READ_KHOOK          _IOW(VPBHP_IOC_MAGIC, 12, VPBHP_DATA)
#define VPBHP_IOC_PCI_READ_KRING          _IOW(VPBHP_IOC_MAGIC, 13, VPBHP_DATA)
#define VPBHP_IOC_PCI_READ_KLDROP         _IOW(VPBHP_IOC_MAGIC, 14, VPBHP_DATA)

#define VPBHP_IOC_PCI_BLOCK_EEREAD        _IOW(VPBHP_IOC_MAGIC, 16, VPBHP_DATA)
#define VPBHP_IOC_PCI_CONF_JOIN        _IOW(VPBHP_IOC_MAGIC, 17, VPBHP_DATA)
#define VPBHP_IOC_PCI_CONF_LEAVE        _IOW(VPBHP_IOC_MAGIC, 18, VPBHP_DATA)
#define VPBHP_IOC_PCI_SBRIDGE_ON        _IOW(VPBHP_IOC_MAGIC, 19, VPBHP_DATA)
#define VPBHP_IOC_PCI_SBRIDGE_OFF        _IOW(VPBHP_IOC_MAGIC, 20, VPBHP_DATA)

 
#else

/* ISA commands */
#define	VPB_IOC_ADD_BOARD	_IO(VPB_IOC_MAGIC, 1)
#define	VPB_IOC_REMOVE_BOARD	_IO(VPB_IOC_MAGIC, 2)
#define	VPB_IOC_BLOCK_WRITE	_IO(VPB_IOC_MAGIC, 3)
#define	VPB_IOC_BLOCK_READ	_IO(VPB_IOC_MAGIC, 4)

/* PCI commands */
#define VPB_IOC_PCI_BLOCK_WRITE    _IO(VPB_IOC_MAGIC, 5)
#define VPB_IOC_PCI_BLOCK_READ     _IO(VPB_IOC_MAGIC, 6)
#define VPB_IOC_PCI_DSP_RESET      _IO(VPB_IOC_MAGIC, 7)
#define VPB_IOC_PCI_DSP_RUN        _IO(VPB_IOC_MAGIC, 8)
#define VPB_IOC_PCI_GET_NUM_CARDS  _IO(VPB_IOC_MAGIC, 9)
#define VPB_IOC_PCI_BLOCK_EEREAD   _IO(VPB_IOC_MAGIC, 10)

#define VPBHP_IOC_PCI_BLOCK_WRITE         _IO(VPBHP_IOC_MAGIC, 1)
#define VPBHP_IOC_PCI_BLOCK_READ          _IO(VPBHP_IOC_MAGIC, 2)
#define VPBHP_IOC_PCI_WD_EN_L             _IO(VPBHP_IOC_MAGIC, 3)
#define VPBHP_IOC_PCI_WD_EN_H             _IO(VPBHP_IOC_MAGIC, 4)
#define VPBHP_IOC_PCI_WDR_L               _IO(VPBHP_IOC_MAGIC, 5)
#define VPBHP_IOC_PCI_WDR_H               _IO(VPBHP_IOC_MAGIC, 6)
#define VPBHP_IOC_PCI_GET_NUM_CARDS       _IO(VPBHP_IOC_MAGIC, 7)
#define VPBHP_IOC_PCI_TX_FIFO_BLOCK_WRITE _IO(VPBHP_IOC_MAGIC, 8)
#define VPBHP_IOC_PCI_RX_FIFO_BLOCK_READ  _IO(VPBHP_IOC_MAGIC, 9)
#define VPBHP_IOC_PCI_TX_FIFO_HOW_EMPTY   _IO(VPBHP_IOC_MAGIC, 10)
#define VPBHP_IOC_PCI_RX_FIFO_HOW_FULL    _IO(VPBHP_IOC_MAGIC, 11)
#define VPBHP_IOC_PCI_READ_KHOOK          _IO(VPBHP_IOC_MAGIC, 12)
#define VPBHP_IOC_PCI_READ_KRING          _IO(VPBHP_IOC_MAGIC, 13)
#define VPBHP_IOC_PCI_READ_KLDROP         _IO(VPBHP_IOC_MAGIC, 14)

#define VPBHP_IOC_PCI_BLOCK_EEREAD        _IO(VPBHP_IOC_MAGIC, 16)
#define VPBHP_IOC_PCI_CONF_JOIN        _IO(VPBHP_IOC_MAGIC, 17)
#define VPBHP_IOC_PCI_CONF_LEAVE        _IO(VPBHP_IOC_MAGIC, 18)
#define VPBHP_IOC_PCI_SBRIDGE_ON        _IO(VPBHP_IOC_MAGIC, 19)
#define VPBHP_IOC_PCI_SBRIDGE_OFF        _IO(VPBHP_IOC_MAGIC, 20)

#endif

#endif


